/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Vector;

import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorTreeContentProvider.ParentChildNode;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class DataCollectorTreeLabelProvider extends LabelProvider
{
	private static Vector icons = new Vector();
	
	/**
	 * Get the text of the element passed in
	 * 
	 * @param element The element whose text is desired.
	 * @return The text of 'element'
	 */
	public String getText(Object element) 
	{
		Object childElement = null;
		if (element instanceof DataCollector) 
			return ((DataCollector)element).getName();
		
		else if(element instanceof ParentChildNode)
		{
			childElement = ((ParentChildNode)element).child; 
			if (childElement instanceof AnalysisType)
				return ((AnalysisType)childElement).getName();
			
			/* For backward compatibility */
			else if (childElement instanceof IProfilingSetType)
				return ((IProfilingSetType)childElement).getName();			
		}
		else if (element instanceof PendingUpdateAdapter)
		{
			return TraceMessages.AttachPendingElement;
		} 
		
		return element == null ? "" : element.toString(); //$NON-NLS-1$
	}

	/**
	 * Return the image that should be associated with 'element'
	 * 
	 * @param element The element whose image is desired
	 * @return The associated image of 'element' 
	 */
	public Image getImage(Object element) 
	{
		ImageDescriptor icon = null;
		Image iconImg = null;
		Object childElement = null;
		
		if (element instanceof DataCollector)
			icon = ((DataCollector)element).getIcon();
		
		if (element instanceof ParentChildNode)
		{
			childElement = ((ParentChildNode)element).child;
			
			if (childElement instanceof AnalysisType)
				icon = ((AnalysisType)childElement).getIcon();
			
			/* For backward compatibility */
			if (childElement instanceof IProfilingSetType)
				icon = ((IProfilingSetType)childElement).getImage();
				
		}
			
		
		if (icon != null)
		{
			iconImg = icon.createImage();
			if (!icons.contains(iconImg))
				icons.add(iconImg);
		}
		
		return iconImg;
	}

	public void dispose() 
	{
		super.dispose();
		for (int i = 0, iconSize = icons.size(); i < iconSize; i++)
			((Image)icons.get(i)).dispose();
		
		icons.clear();		
    }
}
