/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import org.eclipse.hyades.trace.ui.UIPlugin;

/**
 * Defines the constants that are used by multiple classes
 * 
 * @author Ali Mehregani
 */
public class LauncherConstants
{
	/* Used to indicate a co-existance violation with all other entities that exist */
	public static String ALL = "ALL";
	
	/* Line separator as defined by the underlying platform */
	public final static String LINE_SEPARATOR = System.getProperty("line.separator");
	
	/* The id of the local java application launch configuration */ 
	public static final String LOCAL_JAVA_APP_CONF_ID = "org.eclipse.jdt.launching.localJavaApplication";
	
	/* The data collector ID for the JVMPI collector */
	public final static String JVMPI_DATA_COLLECTOR_ID = "org.eclipse.tptp.trace.ui.jvmpiMechanism";
		
	/* The expected command type for the agent controller */
	public final static String SET_OPTION_PREFIX = "SETOPTION";
	public final static String SET_FILTER_PREFIX = "SETFILTER";
	public final static String SET_METHOD_FILTER_PREFIX = "SETMETHODFILTER";
	
	/* The keys for the data stored in the 'Edit Option' and 'Test Availability' buttons */
	public static final String LAUNCH_CONFIGURATION = "0"; 			/* The launch configuration */ 
	public static final String CONFIGURATION_LOADER = "1";			/* The configuration loader */
	public static final String PROFILING_SET_TYPE = "2";			/* The configuration loader */
	public static final String CHECKBOX_TREEVIEWER = "3";			/* The underlying tree */
	public static final String CHECKSTATE_LISTENER = "4";			/* The check state listener */
	
	/* The eclipse main class */
	public static final String ECLIPSE_MAIN = "org.eclipse.core.launcher.Main";
	
	/* The prefix of the dummy profiling sets created */
	public static final String DUMMY_PROFILING_SET_PREFIX = "tptp-dummy-profiling-set-";
	
	/* The default filter id */
	public static final String DEFAULT_FILTER_ID = "org.eclipse.hyades.trace.ui.filterSet.default";
	
	/* The prefix for the agent configuration entry name used to associate an analysis type to an agent */
	public static final String ANALYSIS_TYPE_ASSOCIATION = UIPlugin.getPluginId() + ".ANALYSIS_TYPE_ASSOCIATION";
	
	/* The attach launch configuration type image */
	public static final String CONFIG_TYPE_IMAGE_ATTACH = "org.eclipse.hyades.trace.ui.internal.launcher.localJavaProcess";
}
