/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import java.io.File;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractProcessLauncher;


/**
 * @author Ali Mehregani
 */
public abstract class AbstractJavaDelegate extends AbstractProcessLauncher
{
	/* A helper used to return the appropriate fields stored in a configuration */
	protected JavaConfigurationExtended javaLaunchConfigurationDelegate;

	public AbstractJavaDelegate(String agentName, String agentType)
	{
		super(agentName, agentType);
		javaLaunchConfigurationDelegate = new JavaConfigurationExtended();
	}
	
	protected String getWorkingDirectory(ILaunchConfiguration conf)
	{
		try
		{
			File workingDirectory = javaLaunchConfigurationDelegate.getWorkingDirectory(conf);
			if (workingDirectory != null)
				return workingDirectory.getAbsolutePath();
			return null;
		} 
		catch (CoreException e)
		{
			return null;
		}
	}

	protected String getProgramArguments(ILaunchConfiguration conf)
	{
		try
		{
			return javaLaunchConfigurationDelegate.getProgramArguments(conf);
		} catch (CoreException e)
		{
			return null;
		}
	}

	protected String getMainTypeName(ILaunchConfiguration conf)
	{
		try
		{
			return javaLaunchConfigurationDelegate.getMainTypeName(conf);
		} catch (CoreException e)
		{
			return null;
		}
	}

	protected String getVMArguments(ILaunchConfiguration conf)
	{
		try
		{
			return javaLaunchConfigurationDelegate.getVMArguments(conf);
		} catch (CoreException e)
		{
			return null;
		}
	}

	protected String[] getClasspath(ILaunchConfiguration conf)
	{
		try
		{
			return javaLaunchConfigurationDelegate.getClasspath(conf);
		} catch (CoreException e)
		{
			return null;
		}
	}
	
	
	protected class JavaConfigurationExtended extends AbstractJavaLaunchConfigurationDelegate
	{
		public void setDefaultSourceLocator(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
			super.setDefaultSourceLocator(launch, configuration);
		}

		public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
		{
			/* Doesn't need to be implemented */
		}
	}
}
