/*******************************************************************************
 * Copyright (c) 2008, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel - initial API and implementation
 *    
 * $Id: DefaultJVMVersionDetector.java,v 1.3 2010/03/01 19:59:30 jwest Exp $
 *
 *******************************************************************************/ 
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import java.net.InetAddress;

import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;

public class DefaultJVMVersionDetector implements IJVMVersionDetector {
	public final static long TIMEOUT = 5000L;

//	private static DefaultJVMVersionDetector instance;
	
	private JVMVersionProcessor dataProcessor;
	private Process process;
//	private String jvmVersion = "";
//	private Connection con;
		
//	private static Map /* Connection -> JVM Version */ connectionVersionMap = new HashMap();
	
	/** Lock for access to all the connection static variables */
	private static Object connectionLock = new Object();
	
	/** We cache the last connection*/
	private static Connection lastConnection = null;
	private static String lastConnectionVersion = null;

	public static synchronized DefaultJVMVersionDetector getInstance() {
//		if (instance == null) instance = new DefaultJVMVersionDetector();
//		return instance;
		return new DefaultJVMVersionDetector();
	}
	
	private DefaultJVMVersionDetector() {
		dataProcessor = new JVMVersionProcessor();
	}
	
	public String getJVMVersion(String host, int port) {
		String jvmVersion = null;
						
		Node node = connect(host, port);
		if (node == null || !node.isConnected()) return "";

		synchronized(connectionLock) {

			if(node.getConnection() != null) {
								
				if(lastConnection == null || !lastConnection.equals(node.getConnection())) {
					// If another connection was established (e.g. with a different host + port), 
					// then don't use the cached value
				} else {
					// Match, use the last connection
					return lastConnectionVersion;
				}
			}
		}
		
		if (launchJVM(node)) {
			synchronized (dataProcessor) {
				if (dataProcessor.getOutput().length() == 0) 
					try { dataProcessor.wait(TIMEOUT); } catch (Exception e) {}
			}
		}

		close();
		
		jvmVersion = dataProcessor.getOutput();
		
		synchronized(connectionLock) {
			// We received a result for this host/port combination, so store the connection and version
			lastConnection = node.getConnection();
			lastConnectionVersion = jvmVersion;
		}
		
		return jvmVersion;
	}

	private Node connect(String host, int port) {
		Node node;
		try {
			host = CommonUITraceConstants.LOCAL_HOST.equals(host) ? InetAddress.getLocalHost().getHostName() : host;
			node = PDCoreUtil.profileConnect(host, String.valueOf(port), false);
		} catch (Exception e) {
			node = null;
		}
		
		return node;
	}
	
	private boolean launchJVM(Node node) {
		if (node == null || !node.isConnected()) return false;

		boolean r;

		try	{
			dataProcessor.clear();

			process = ProcessFactory.createProcess(node);
			process.setExecutable("java.exe");
			process.setParameters(" -version");
			process.getConsole().setDataProcessor(dataProcessor);
			process.launch();
			
			r = true;
		}
		catch (Exception e) {
			r = false;
		}
		
		return r;
	}

	private void close() {
		if (process == null) return;

		Console console = process.getConsole();
		if (console != null) console.close();
	}
	
	class JVMVersionProcessor implements DataProcessor {
		private StringBuffer output = new StringBuffer();

		public void incommingData(byte[] buffer, int length, InetAddress peer) {
			appendOutput(new String(buffer, 0, length));
		}

		public void incommingData(char[] buffer, int length, InetAddress peer) {
			appendOutput(new String(buffer, 0, length));
		}

		public void invalidDataType(byte[] data, int length, InetAddress peer) {}
		public void waitingForData(){}

		private synchronized void appendOutput(String buffer) {
			output.append(buffer);
			notifyAll();
		}

		public String getOutput() {
			return output.toString();
		}
		
		public void clear() {
			output.setLength(0);
		}
	}
}
