/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractDCMutualLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.AgentSelection;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorAgentAttach;

/**
 * The launcher attach delegate for logging agents.
 * 
 * @author Ali Mehregani
 */
public class LoggingAttachLauncherDelegate extends AbstractDCMutualLauncher implements IDataCollectorAgentAttach
{
	/**
	 * The launch configuration
	 */
	private ILaunchConfiguration configuration;


	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher#createNode()
	 */
	public Node createNode()
	{
		/* Doesn't need to be implemented */
		return null;
	}

	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher#isProcessLauncher()
	 */
	public boolean isProcessLauncher()
	{		
		return false;
	}
	
	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher#preLaunch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
	{
		this.configuration = configuration;
	}

	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorAgentAttach#launch(org.eclipse.tptp.trace.ui.provisional.launcher.AgentSelection[])
	 */
	public void launch(AgentSelection[] selection) throws CoreException
	{
		PDCoreUtil.monitorAgents(selection, configuration, true);
	}
	

	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher#postLaunch(org.eclipse.core.runtime.IStatus)
	 */
	public void postLaunch(IStatus launchStatus) throws CoreException
	{
		
	}
}
