/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.tptp.trace.ui.provisional.launcher.AbstractDCMutualLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.AgentSelection;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorAgentAttach;
import org.eclipse.tptp.trace.ui.provisional.launcher.IParameterExtractor;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;

/**
 * The PI attach launcher delegate.
 * 
 * @author Ali Mehregani
 */
public class PIAttachLauncherDelegate extends AbstractDCMutualLauncher implements IDataCollectorAgentAttach, IParameterExtractor
{
	/**
	 * Indicates whether agents should automatically be monitored
	 */
	private boolean autoMonitor;
	
	/**
	 * The launch configuration
	 */
	private ILaunchConfiguration configuration;

	public Node createNode()
	{
		/* Doesn't need to be implemented */
		return null;
	}

	public boolean isProcessLauncher()
	{		
		return false;
	}

	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher#preLaunch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException
	{
		autoMonitor = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, true);
		this.configuration = configuration;
	}

	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorAgentAttach#launch(java.util.ArrayList)
	 */
	public void launch(AgentSelection[] selection) throws CoreException
	{ 
		PDCoreUtil.monitorAgents(selection, configuration, autoMonitor);
	}
	
	/**
	 * @see org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher#postLaunch(org.eclipse.core.runtime.IStatus)
	 */
	public void postLaunch(IStatus launchStatus) throws CoreException
	{
		/* Doesn't need to be implemented */
	}

	public ProcessParameters getProcessParameters(ILaunchConfiguration launchConfiguration) {
		return new ProcessParameters("-XrunpiAgent",null,null);
	}

}
