/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;

/**
 * Extends the XML trace data processor so that it can report 
 * statistical measurements (e.g. the size of the last incomming event).
 * The overhead should be next to nothing.
 * 
 * @author Ali Mehregani
 */
public class StatGeneratorDataProcessor extends XMLTraceDataProcessor 
{
	/** The size of the last incoming event */
	private int sizeOfLastEvent;
	
	
	/**
	 * Constructor
	 * 
	 * @param agentProxy The agent proxy
	 */
	public StatGeneratorDataProcessor(TRCAgentProxy agentProxy)
	{
		super(agentProxy);
	}

	
	/**
	 * Invoked when there is incoming events.
	 * 
	 * @param buffer The buffer to be processed
	 * @param length The length of the buffer
	 * @param peer The peer host
	 */
	public void incommingData(byte[] buffer, int offset, int length, java.net.InetAddress peer)
	{
		sizeOfLastEvent = length;
		super.incommingData(buffer, offset, length, peer);
	}
	
	
	/**
	 * Invoked when there is incoming data
	 * 
	 * @param buffer The buffer to be processed
	 * @param length The length of the buffer
	 * @param peer The peer host
	 */
	public void incommingData(char[] buffer, int offset, int length, java.net.InetAddress peer) 
	{
		sizeOfLastEvent = length;
		super.incommingData(buffer, offset, length, peer);
	}
	
	
	/**
	 * Returns the size of the last incoming event.
	 * 
	 * @return The size of the last incoming event.
	 */
	public int getSizeOfLastEvent()
	{
		return sizeOfLastEvent;
	}
	
	
	/**
	 * Resets the statistical measurements that it keeps track.
	 */
	public void resetStats()
	{
		sizeOfLastEvent = 0;
	}
}
