/**********************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceConstants;


/**
 * This class provides the toolbar items that applies to agents.
 *  
 * @author Ali Mehregani
 */
public abstract class AbstractAgentToolbarProvider extends AbstractAgentControlProvider
{   
	/** The id of the contributed items */
	public static final String START_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.startMonitoring";
	public static final String PAUSE_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.stopMonitoring";
	public static final String DETACH_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.detach";
	public static final String TERMINATE_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.terminate";
	public static final String REFRESH_VIEW_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.refreshViews";
	public static final String REFRESH_OPTIONS = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.refreshOptions";
	
	/** The start monitoring toolbar item */
	private IControlItem startMonitoring;
	
	/** The pause monitoring toolbar item */
	private IControlItem pauseMonitoring;
	
	/** The detach toolbar item */
	private IControlItem detach;
	
	/** The terminate toolbar item */
	private IControlItem terminate;
	
	/** The refresh control item */
	private IControlItem refreshView;
	
	/** The automatic refresh control item. Used */
	private IControlItem automaticRefresh;
	
    /**
     * @see AbstractControlProvider#initializeControlItems()
     */
	protected void initializeControlItems() 
	{
		addControlItem(createStartMonitoringControlItem());
		addControlItem(createPauseMonitoringControlItem());
		addControlItem(createDetachControlItem());
		addControlItem(createTerminateControlItem());
		addControlItem(createRefreshViewsControlItem());
		addControlItem(createAutomaticRefreshControlItem());  /* Added for bugzilla 153453 */
	}
	
	
	/**
	 * Overwrite this method so that the id & group name of the 
	 * start monitoring control item can be changed.
	 * 
	 * @return A control item used to resume monitoring
	 */
	protected IControlItem createStartMonitoringControlItem()
    {
		if (startMonitoring != null)
			return startMonitoring;
		
		startMonitoring = makeToolbarReady(super.createStartMonitoringControlItem(), START_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_MONITOR_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_RESUME));
		return startMonitoring;
    }
	
	
	/**
	 * Overwrite this method so that the id & group name of the 
	 * pause monitoring control item can be changed.
	 * 
	 * @return A control item used to pause monitoring
	 */
	protected IControlItem createPauseMonitoringControlItem()
    {
		if (pauseMonitoring != null)
			return pauseMonitoring;
		pauseMonitoring = makeToolbarReady(super.createPauseMonitoringControlItem(), PAUSE_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_MONITOR_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_PAUSE));
		
		return pauseMonitoring;
    }
	
	/**
	 * Overwrite this method so that the id & group name of the 
	 * detach control item can be changed.
	 * 
	 * @return A control item used to detach a process
	 */
	protected IControlItem createDetachControlItem()
    {
		if (detach != null)
			return detach;
		detach = makeToolbarReady(super.createDetachControlItem(), DETACH_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_MONITOR_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_DETACH_AGENT));
		
		return detach;
    }
	
	/**
	 * Overwrite this method so that the id & group name of the 
	 * terminate control item can be changed.
	 * 
	 * @return A control item used to terminate a process
	 */
	protected IControlItem createTerminateControlItem()
    {
		if (terminate != null)
			return terminate;
		
		terminate = makeToolbarReady(super.createTerminateControlItem(), TERMINATE_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_MONITOR_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_TERMINATE));
		return terminate;
    }
	
	
	/**
	 * Overwrite this method so that the id & group name of the 
	 * refresh control item can be changed.
	 * 
	 * @return A control item used to refresh views
	 */
	protected IControlItem createRefreshViewsControlItem()
    {
		if (refreshView != null)
			return refreshView;
		
		refreshView = makeToolbarReady(super.createRefreshViewsControlItem(), REFRESH_VIEW_TOOLBAR_ITEM, CommonUITraceConstants.PROFILE_REFRESH_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_REFRESH_VIEWS));
		return refreshView;
    }
	
	/**
	 * Navid Mehregani - bugzilla 153453 
	 * A toolbar button to allow the user to easily change the refresh options
	 * @return A control item used to change the refresh options
	 */
	protected IControlItem createAutomaticRefreshControlItem()
    {
		if (automaticRefresh != null)
			return automaticRefresh;
		
		automaticRefresh = makeToolbarReady(super.createRefreshOptionControlItem(), REFRESH_OPTIONS, CommonUITraceConstants.PROFILE_REFRESH_GROUP, TraceUIImages.INSTANCE.getImageDescriptor("d", TraceUIImages.IMG_REFRESH_OPTIONS));
		return automaticRefresh;
    }
	
	
	protected IControlItem makeToolbarReady (IControlItem controlItem, String newId, String newGroupName, ImageDescriptor disableIcon)
	{
		controlItem.setId(newId);
		controlItem.setGroup(newGroupName);
		controlItem.setDisabledImageDescriptor(disableIcon);
		controlItem.setToolTipText(UIPlugin.removeAccelerators(controlItem.getText()));
		controlItem.setText("");
		return controlItem;
	}
}
