/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * A primitive implementation of a control item.  Subclasses can extend
 * and overwrite only the desired methods.
 * 
 * @author Ali Mehregani
 */
public class ControlItem extends Action implements IControlItem
{
	private static final String DEFAULT_GROUP = "group.default";
	
	private String groupName, text;	
	protected StructuredSelection input;
	
	public ControlItem()
	{
		
	}
		
	public ControlItem(String itemId, String groupName, String text, ImageDescriptor imageDescriptor)
	{
		this.groupName = groupName;
		this.text = text;
		super.setImageDescriptor(imageDescriptor);
		super.setId(itemId);
	}
	
	
	public String getGroup()
	{
		if (groupName != null)
			return groupName;
		return DEFAULT_GROUP;
	}

	public void setGroup(String groupName)
	{
		this.groupName = groupName; 
	}
	
	public void setInput(StructuredSelection input)
	{
		this.input = input;
	}

	
	public String getText()
	{
		return text;
	}
	
	
	public boolean equals (Object o)
	{
		if (o == null)
			return false;
		
		if (o instanceof IControlItem)
		{
			String objectItemId = ((IControlItem)o).getId();
			
			if (objectItemId != null)
			{
				boolean areIdsSame = objectItemId.equals(this.getId());
				if (areIdsSame)
					return true;
			}
		}
		return this.getClass().equals(o.getClass());
	}
}
