/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredSelection;


/**
 * Represents a control item that is affiliated with a controllable entity.
 * Subclasses are expected to extend {@link org.eclipse.jface.action.Action}
 * and implement this interface.
 *  
 * @author Ali Mehregani
 */
public interface IControlItem extends IAction
{
	/**
	 * Returns the group name of this control item.  The group name of a control
	 * item determines where to add the item in a container.
	 *  
	 * @return The group name of the item
	 */
	public String getGroup();
	
	
	/**
	 * Sets the group of this control item
	 * 
	 * @param groupName The group name
	 */
	public void setGroup(String groupName);
	
	/**
	 * Sets the input for this control item.  The input should be used as the
	 * context in which this action will be applied to.
	 * 
	 * @param input The input of this control item.
	 */
	public void setInput (StructuredSelection input);
}
