/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.jface.viewers.StructuredSelection;

/**
 * A control provider will set one or more control options that can be invoked by the user on a
 * supported entity.   There is only one provider invoked for a contributed entity.  The
 * <code> setInput </code> method is used to set the current input of the provider.  
 * 
 * Clients may choose to extend any one of the listed classes below as opposed to directly
 * implementing this method.
 *  
 * @author Ali Mehregani
 *
 */
public interface IControlProvider 
{
	/**
	 * This method is invoked once to give the control provider a chance
	 * to initialize.  
	 * @param entity The entity that this control provider is affiliated with
	 */
	public void initialize(String entity);

	
	/**
	 * Invoked to set the current input that should be used as the
	 * context of this provider.
	 * 
	 * @param input The input
	 */
    public void setInput(StructuredSelection input);
    
    
    /**
     * Creates and returns the control items of this provider.  The
     * control items are used to create UI entities such as menu
     * items or toolbar items.
     * 
     * @return The control items of this provider
     */
    public IControlItem[] createControlItems();
    
}
