/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.StructuredSelection;


/**
 * This interface is used to alter the state of processes.  The processes can be 
 * independent of the back-end data collector that manages it.  It can even be
 * a place holder that does not correspond to a specific system process. 
 *  
 * @author Ali Mehregani
 */
public interface IProcessStateModifier 
{
	/**
	 * Terminate the processes that this state modifier is affiliated
	 * with.
	 * 
	 * @throws CoreException To indicate any error that may have occurred
	 * while terminating the processes
	 */
    public void terminate() throws CoreException;
    
    
    /**
     * Indicate whether the affiliated processes can be terminated.
     * True will indicate that the processes can be terminated.
     * 
     * @retrun A flag indicating whether the associated processes
     * can be terminated
     */
    public boolean canTerminate();
    
    
	/**
	 * Sets the input for this state modifier.  The input should be used as the
	 * context in which this state modifier will be applied to.
	 * 
	 * @param input The input of this state modifier.
	 */
	public void setInput (StructuredSelection input);
}
