/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.control.provider;


import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.OpenTraceReportAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshFromLocalAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshTreeAction;
import org.eclipse.hyades.ui.extension.INavigatorContribution;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.trace.ui.internal.control.provider.TraceControlItemManager;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;

/**
 * The control provider for logical items that appear in the profiling
 * monitor view.  An example of a logical item are analysis types that appear 
 * under an agent. 
 * 
 * @author Ali Mehregani
 */
public class LogicalItemControlProvider extends AbstractControlProvider 
{	
	/** The report item */
	private IControlItem reportItem;
	
	/** The import item */
	private IControlItem importItem;
	
	/** The export item */
	private IControlItem exportItem;
	
	/** The refresh item */
	private IControlItem refreshItem;
	
	/** The unload data item */
	private IControlItem unloadDataItem;
	

	/**
	 * Subclasses are expected to overwrite this method to add their own
	 * control items to the protected field: <code>controlItems</code>.
	 * It's not recommended for contriabutors to overwrite createContrlItems.
	 * 
	 */
    protected void initializeControlItems()
	{
    	controlItems.clear();
    	addControlItem (createReportControlItem());
    	addControlItem (createImportControlItem());
    	addControlItem (createExportControlItem());
    	addControlItem (createRefreshControlItem());
    	addControlItem (createUnloadControlItem());
	}

    
    
    protected IControlItem createReportControlItem()
    {
    	if (reportItem != null && !isContextDifferent)
    	{
    		((OpenTraceReportAction)((ControlItemAdapter)reportItem).getAction()).selectionChanged((IStructuredSelection)TraceControlItemManager.getNavigator().getViewer().getSelection());
    		return reportItem;
    	}
    	
    	OpenTraceReportAction openReportAction = new OpenTraceReportAction();
		openReportAction.selectionChanged((IStructuredSelection)TraceControlItemManager.getNavigator().getViewer().getSelection());
		if(openReportAction.isApplicableForSelection())
		{
			reportItem = new ControlItemAdapter(INavigatorContribution.GROUP_IMPORT, openReportAction);
		}
    		
    	return reportItem;
    }
    
    
    protected IControlItem createImportControlItem()
    {
    	if (importItem != null && !isContextDifferent)
    		return importItem;
    	
    	importItem = new ControlItemAdapter (INavigatorContribution.GROUP_IMPORT, new ImportResourcesAction(UIPlugin.getActiveWorkbenchWindow()));
    	return importItem;
    }
    
    
    protected IControlItem createExportControlItem()
    {
    	if (exportItem != null && !isContextDifferent)
    		return exportItem;
    	
    	exportItem = new ControlItemAdapter (INavigatorContribution.GROUP_IMPORT, new ExportResourcesAction(UIPlugin.getActiveWorkbenchWindow()));
    	return exportItem;
    }
    
    
    protected IControlItem createRefreshControlItem()
    {
    	if (refreshItem != null && !isContextDifferent)
    		return refreshItem;
    	
    	refreshItem = new ControlItemAdapter (INavigatorContribution.GROUP_REFRESH, new RefreshTreeAction(TraceControlItemManager.getNavigator()));
    	return refreshItem;
    }
    
    
    protected IControlItem createUnloadControlItem()
    {
    	if (unloadDataItem != null && !isContextDifferent)
    		return unloadDataItem;
    	
    	unloadDataItem = new ControlItemAdapter (INavigatorContribution.GROUP_REFRESH, new RefreshFromLocalAction(TraceControlItemManager.getNavigator()));
    	return unloadDataItem;
    }
    
}
