/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * An abstract class for self manageable launchers to extend.  Alternatively, contributors can
 * implement {@link IDataCollectorSelfManageableLauncher}
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractDCSelfManageableLauncher implements IDataCollectorSelfManageableLauncher
{
	/**
	 * Return false to indicate that this launcher is non-mutual (A.K.A. Self-manageable)
	 */
	public boolean isMutualLauncher()
	{
		return false;
	}
	
	/**
	 * {@link IDataCollectorSelfManageableLauncher#launch(ILaunchConfiguration, String, ILaunch, IProgressMonitor)
	 */
	abstract public void launch(ILaunchConfiguration launchConfiguration, String mode, ILaunch launch, IProgressMonitor monitor);

}
