/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;


/**
 * Represents a selected agent during the attach scenario.  This class is intended
 * to be used as-is.  It is not intended to be subclassed.
 * 
 * @author Ali Mehregani
 */
public class AgentSelection
{
	/**
	 * The agent proxy models an agent
	 */
	private TRCAgentProxy agentProxy;
	
	/**
	 * The actual agent.  This can be of type {@link org.eclipse.hyades.internal.execution.local.control.Agent} or 
	 * {@link org.eclipse.tptp.platform.execution.client.agent.IAgent}
	 */
	private Object agent;

	/**
	 * @return the agentProxy
	 */
	public TRCAgentProxy getAgentProxy()
	{
		return agentProxy;
	}

	/**
	 * @param agentProxy the agentProxy to set
	 */
	public void setAgentProxy(TRCAgentProxy agentProxy)
	{
		this.agentProxy = agentProxy;
	}

	/**
	 * @return the agent
	 */
	public Object getAgent()
	{
		return agent;
	}

	/**
	 * @param agent the agent to set
	 */
	public void setAgent(Object agent)
	{
		this.agent = agent;
	}
}
