/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;


/**
 * Used to check the availability of a service.  This interface is commonly used to ensure
 * that a back-end service (e.g. An Agent Controller's agent) is available.
 * 
 * @author Ali Mehregani
 */
public interface IAvailabilityTester
{
	
	/**
	 * Reset this availability tester with the current configuration that
	 * will serve as context.
	 * 
	 * @param configuration The launch configuration that will be used to 
	 * reset this tester.
	 */
	public void reset (ILaunchConfiguration configuration);
	
	
	/**
	 * Returns a status that indicates the availability of a service that is
	 * associated with this availbility tester.  If the user's environment is not changed,
	 * then consecutive calls to this method is expected to return the same status.
	 * 
	 * <p>
	 * Clients will often use a test availibility class to display an info, warning, 
	 * or error dialog based on the status returned.
	 * </p>
	 *  
	 * @return A status indicating the availability of a service. 
	 */
	public IStatus isServiceAvailable();
}
