/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * This interface is used to filter data collectors or analysis types 
 * based on a criteria.  For example, a contributor can associate 
 * a filtration class with a data collector/analysis type to have it excluded 
 * based on the environment of the targeted machine. 
 * The filtration criteria is left to the implementation. 
 * 
 * @author Ali Mehregani
 */
public interface ICollectorFiltration
{
	/**
	 * Apply the filtration and return true if the associated entity should be displayed.
	 * Otherwise false should be returned.
	 *  
	 * @param id The ID of the entity that the filtration should be applied to
	 * @param configuration The launch configuration
	 * @param context The context that the entity is in.  The context can be null
	 * @return true if the entity should be included and false otherwise
	 */
	public boolean include(String id, ILaunchConfiguration configuration, Object context);
}
