/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

/**
 * Represents a configuration wizard that can be associated with data collectors or analysis types
 * in the launch configuration.
 *  
 * @author Ali Mehregani
 */
public interface IConfiguration extends ILightConfiguration
{	
	/**
	 * This method is invoked to give the implementor the chance of initializing 
	 * the wizard pages.  This method is called prior to all other methods explicitly
	 * defined in this interface.
	 */
	public void initialize();
	
	
	/**
	 * Retuns the configuration pages that will be displayed in the wizard.  The order
	 * in which these pages are returned is the order in which they'll be displayed to 
	 * the user.  At least one page should be returned.  This method may get invoked 
	 * multiple times.  It's expected to return the same set of objects everytime it is
	 * invoked.
	 * 
	 * @return A set of pages representing the wizard pages. 
	 */
	public IConfigurationPage[] getConfigurationPages();


	/**
	 * Invoked when the user ends the configuration wizard by clicking the finish button.
	 * This gives contributors the chance of adding the neccessary attributes that corresponding
	 * to the configuration settings.
	 *  
	 * @param workingCopy The working copy of the launch configuration
	 * @return True if the configuration wizard ended successfully; false otherwise.
	 */
	public boolean finishConfiguration(ILaunchConfigurationWorkingCopy workingCopy);
}
