/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;

/**
 * Represents a configuration page displayed as part of a configuration wizard that can be
 * associated with either a data collector or an analysis type.  
 * 
 * @author Ali Mehregani
 */
public interface IConfigurationPage
{
	/**
	 * This method is invoked to reset the values of controls displayed as part of the wizard page.  
	 * The argument will commonly be used to extract known attribute values that can be used as the 
	 * value for displayed controls.  This method can be invoked before or after the invocation of 
	 * {@link IConfigurationPage#createControl(Composite)}
	 *
	 * @param launchConfiguration The launch configuration that is currently selected.
	 */
	public void reset(ILaunchConfiguration launchConfiguration);
	
	
	/**
	 * Create the controls of the page using 'parent' as the 
	 * parent composite
	 * 
	 * @param parent The parent composite
	 */
	public void createControl(Composite parent);
	
	
	/**
	 * Returns the page name of this page.  The value
	 * return CANNOT be null.
	 * 
	 * @return The page name
	 */
	public String getPageName();
	
	
	/**
	 * Returns the title of the configuration page that
	 * will displayed as part of the wizard.
	 * 
	 * @return The title of the page
	 */
	public String getTitle();
	
	
	/**
	 * Return the wizard banner for this page.
	 * 
	 * @return A wizard banner
	 */
	public ImageDescriptor getWizardBanner();
	

	/**
	 * Return the description for this configuration
	 * page.
	 * 
	 * @return The description of the page
	 */
	public String getDescription();
	
	
	
	/**
	 * Clients should be able to register listners that will be notified
	 * when there is a change in a page that might possibly cause an error.
	 * <p>
	 * This class is obligated to:
	 * <ol>
	 *  <li> 
	 *  	invoke <code>statusListener.handleErrorEvent(String)</code> when 
	 *  	there is an error in the current page.
	 *  </li>
	 *  <li>
	 *  	invoke <code>statusListener.handleOKEvent () </code> when there
	 *      are not errors in the current page.
	 *  </li>
	 * </p>
	 * 
	 * @param statusListener The listener object to be registered
	 */
	public void addErrorListener(IStatusListener statusListener);


}
