/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.CoreException;


/**
 * This launcher should be used when attaching to one or more agents.  The primary attach delegate
 * will invoke the following method of this type of launcher in the order shown below:
 * <ol>
 * 	<li>preLaunch(...)</li>
 * 	<li>launch(...)</li>
 * 	<li>postLaunch(...)</li>
 * </ol>
 * 
 * @author Ali Mehregani
 */
public interface IDataCollectorAgentAttach extends IDataCollectorMutualLauncher
{
	/**
	 * Gives the chance for the launcher to perform any operations needed to attach
	 * to the agents.  This method is intended to handle agent-specific operations during
	 * an attach use case (e.g. setting required agent configurations).
	 *   
	 * @param selection The selected agents that will need to be attached to
	 * @throws CoreException In case of any unexpected error
	 */
	public void launch (AgentSelection[] selection) throws CoreException;
}
