/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

/**
 * Represents a mutual launcher that doesn't launch an actual process.  It only
 * creates and feeds a new agent.  An example of a data collector that is of this
 * nature is a monitoring agent.  The process is often fake and the agent is the
 * entity that provides the data. 
 * 
 * @see IDataCollectorAgentAttach
 * @author Ali Mehregani
 */
public interface IDataCollectorAgentLauncher extends IDataCollectorMutualLauncher
{
	
	/**
	 * Prepares the model entity representing the agent that will be a result of the
	 * launch.
	 * 
	 * @param trcProcessProxy The model entity representing a process. 
	 * @return The primary launcher doesn't use the returned value.  In fact the 
	 * returned value can be null if contributors choose not to use the execution 
	 * framework.
	 */
	public Agent createAgent(TRCProcessProxy trcProcessProxy)  throws CoreException;
}
