/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;


/**
 * Represents a common interface that is used to launch a data collector
 * with a set of analysis types.  The launch decesion tree appears below. 
 * The tree is broken down into the following interfaces:
 * 
 * <table border = "1" width="100%">
 * 	<tr>
 * 		<td valign="top">
 * 		{@link IDataCollectorBaseLauncher}
 * 		</td>
 * 		<td>
 * 		isMutualLauncher()
 * 		</td>
 *	</tr>
 *
 *	<tr>
 * 		<td valign="top">
 * 		{@link IDataCollectorSelfManageableLauncher}
 * 		</td>
 * 		<td>
 * 		launch()
 * 		</td>
 *	</tr>
 *
 * 	<tr>
 * 		<td valign="top">
 * 		{@link IDataCollectorMutualLauncher}
 * 		</td>
 * 		<td>
 * 		preLaunch() <br/>
 * 		isProcessLauncher() <br/>
 * 		prepareAgentLaunch() <br/>
 * 		postLaunch() <br/>
 * 		</td>
 *	</tr>
 *
 * 	<tr>
 * 		<td valign="top">
 * 		{@link IDataCollectorProcessLauncher}
 * 		</td>
 * 		<td>
 * 		createProcess() <br/>
 * 		addProcessParameters() <br/>
 * 		</td>
 *	</tr>
 *	
 *	<tr>
 * 		<td valign="top">
 * 		{@link IDataCollectorAgentLauncher}
 * 		</td>
 * 		<td>
 * 		prepareAgentLaunch() <br/> 		
 * 		</td>
 *	</tr>
 * </table>
 * <br/><br/><br/><br/>
 * <pre>
 *              isMutualLauncher()
 *                  /       \
 *                 /         \
 *             [false]      [true]
 *               /             \
 *              /               \
 *          launch()          preLaunch()
 *                               |
 *                               |
 *                         isProcessLauncher()
 *                               /      \
 *                              /        \
 *                          [false]     [true]
 *                            /            \
 *                           /             |
 *                    +createNode()    +createNode()
 *                         /               |
 *               prepareAgentLaunch()  +createProcess()  
 *                       /                 |             
 *                      /                  |             
 *                postLaunch()             |
 *                                getProcessParameters()
 *                                         |
 *                                 configuratProcess()
 *                                         |
 *                                    createAgent()
 *                                         |
 *                                     postLaunch()
 * 
 * +createNode() or createProcess() will not be called if an earlier delegate has already created 
 * the node/process.
 * </pre>
 * 
 * @author Ali Mehregani
 */
public interface IDataCollectorBaseLauncher
{
	/**
	 * Returns true if the launcher wishes to manage the launch process itself rather than
	 * have the primary launcher code handling it; false otherwise
	 * 
	 * @return A boolean indicating whether launch should be handled without the involvement
	 * of the general launch delegate
	 */
	public boolean isMutualLauncher();
}
