/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Node;


/**
 * The base interface for a mutual launcher.  See {@link IDataCollectorBaseLauncher} for
 * more details.  A mutual launcher will co-exist and collaborate with other launchers to use
 * the same model entities when performing a launch.
 * 
 * @author Ali Mehregani
 */
public interface IDataCollectorMutualLauncher extends IDataCollectorBaseLauncher
{
	/**
	 * A chance for the launcher to collect the necessary attributes from the configuration 
	 * and prepare for the launch of the process.
	 * 
	 * @param configuration The launch configuration 
	 * @param mode The mode of the launch
	 * @param launch The launch 
	 * @param monitor The monitor
	 */
	public void preLaunch (ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor)  throws CoreException;
	
	
	/**
	 * Returns true if the launcher will be creating a execution process
	 * object that will be launched later.
	 *  
	 * @return A boolean indicating whether the launcher will launch an actual process.
	 */
	public boolean isProcessLauncher();	 
	
	
	/**
	 * Creates the execution node and returns the resolved node
	 * name.
	 *  
	 * @return The primary launcher doesn't use the returned value.  In fact the 
	 * returned value can be null if contributors choose not to use the execution 
	 * framework.
	 */
	public Node createNode();	 
	
	
	/**
	 * Invoked for the launcher to have the chance of performing any post-launch operations
	 * necessary.
	 * 
	 * @param launchStatus Indicates the overall status of the launch process
	 */
	public void postLaunch(IStatus launchStatus) throws CoreException;
}
