/**********************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;


/**
 * Represets a mutual launcher that needs an actual process to be launched.
 * See {@link IDataCollectorBaseLauncher} for more details
 * 
 * @author Ali Mehregani
 */
public interface IDataCollectorProcessLauncher extends IDataCollectorMutualLauncher, IParameterExtractor
{
	/**
	 * Creates and returns a process representing an execution process that will be
	 * launched using any arbitrary back-end driver.
	 * 
	 * @return The primary launcher will use the returned value to build the model
	 * entity to represent a process.  The expected returned value should be
	 * a valid (non-null) process.
	 */
	public Process createProcess ()  throws CoreException;
	
	
	/**
	 * This is a chance that a client has to configure the process
	 * before it is launched.  Clients can for example use this opportunity
	 * to register listeners.
	 * 
	 * @param process The process that will eventually be launched
	 * @param trcProcessProxy the model entity representing a process
	 */
	public void configureProcess(Process process, TRCProcessProxy trcProcessProxy)  throws CoreException;
	
	
	/**
	 * Prepares the back-end and model agent entities.  The back-end agent will need to be
	 * associated with process and the agent model entity will need to be associated with
	 * trcProcessProxy.  Contributors are not limited to associating a single agent
	 * to a process.  There can be multiple agents associated with the process to
	 * be launched.
	 * 
	 * @param process The process that will eventually be launched.
	 * @param trcProcessProxy The model entity representing a process. 
	 * @return The primary launcher doesn't use the returned value.  In fact the 
	 * returned value can be null if contributors choose not to use the execution 
	 * framework.
	 */
	public Agent createAgent(Process process, TRCProcessProxy trcProcessProxy)  throws CoreException;


}
