/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;


/**
 * Used to represent a self manageable launcher that will manage the creation of
 * back-end and front-end objects for completing the launch.  See {@link IDataCollectorBaseLauncher} 
 * for more details.
 * 
 * @author Ali Mehregani
 */
public interface IDataCollectorSelfManageableLauncher extends IDataCollectorBaseLauncher
{
	/**
	 * Launches the process that this data collector is expected to launch.  This method
	 * will only be invoked if isMutualLauncher() returns false.
	 * 
	 * @param launchConfiguration The launch configuration
	 * @param mode The mode launching in.
	 * @param launch The launch object
	 * @param monitor The monitor indicating the progress of the launch
	 */
	public void launch(ILaunchConfiguration launchConfiguration, String mode, ILaunch launch, IProgressMonitor monitor)  throws CoreException;
	

}
