/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * This interface is used to define a verification mechanism for data collectors and 
 * analysis types.  These operations are invoked at different stages during a launch
 * session. 
 * 
 * @author Ali Mehregani
 */
public interface ILaunchValidator
{
	/**
	 * This method is invoked when the current configuration is updated.  It should either
	 * return an OK status or null if the current configuration is valid; otherwise an error
	 * condition is assumed and the status' message is displayed to the user.
	 * 
	 * @param configuration The configuration
	 * @return Status.OK_STATUS or null if the configuration is valid and can be applied; otherwise an
	 * appropriate status should be returned.
	 */
	public IStatus validateConfiguration(ILaunchConfiguration configuration);
	
	
	/**
	 * This method is called from the launch configuration just prior to the launch of the application.
	 * If the method returns an OK status or null, then the launch will proceed.  If the status 
	 * is not OK or null, then a message will be displayed to the user.  The operation will
	 * halt if the severity of the returned message is IStatus.ERROR; otherwise the launch will
	 * continue;
	 * 
	 * @param config The configuration
	 * @return An status indicating the validity of the configuration
	 */
	public IStatus launchNotification(ILaunchConfiguration config);
	
	
}
