/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;



/**
 * This represents a non-editable configuration (i.e. A light configuration
 * that can be associated with either data collectors or analysis types)
 * 
 * @author Ali Mehregani
 */
public interface ILightConfiguration
{
	/* The prefix for option names defined for Agent Controller */  
	public static final String AC_OPT_PREFIX_NAME = "SETOPTION_";
	
	/**
	 * This method should map this configuration to profiling attributes that
	 * are understandable by the back-end data collector.  The set of attributes
	 * returned here can for example be used to build the configuration for
	 * an execution entity (e.g. an agent).  Alternatively the launch delegate can just
	 * use the launch configuration to extract the stored attributes 
	 * (e.g. ILaunchConfiguration.getAttribute(name, defaultValue).  This approach
	 * will of course require the launch delegate to be aware of the attribute names
	 * stored in the launch configuration <br/>
	 * 
	 * If Agent Controller is being used as the back-end data collector, then the option's
	 * name must begin with the prefix: 
	 * {@link org.eclipse.tptp.trace.ui.provisional.launcher.ILightConfiguration#AC_OPT_PREFIX_NAME}
	 * 
	 * @return A set of options understandable by the back-end data collector
	 */
	public DataCollectionEngineAttribute[] getAttributes();
}
