/**********************************************************************
 * Copyright (c) 2007 IBM Corporation, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;

import org.eclipse.debug.core.ILaunchConfiguration;

/**
 * Interface for process that requires parameters to launch
 * 
 * @author Eugene Chan
 *
 */
public interface IParameterExtractor {
	
	/**
	 * Returns the process parameters that will be used to set the parameter of 
	 * the process being launched.  Contributors can use configureProcess to tag 
	 * along their own parameters BUT this may have the unwanted effect of 
	 * overwriting other data collector parameters.
	 * 
	 * This is required when targeting an attach launcher in profile on server feature,
	 * the executableParameters of processParameters is used and appended to the VM 
	 * argument list of the server launcher. 
	 * Alternatively, extension poing 
	 * org.eclipse.tptp.platform.profile.server.wst.serverProfileExtenders
	 * can be used for supplying the VM argument of a particular launcher in profile
	 * on server 
	 * 
	 * @param the launch configuration
	 * @return the process parameters
	 */
	public ProcessParameters getProcessParameters(ILaunchConfiguration launchConfiguration);
	
}
