/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.trace.ui.provisional.launcher;


/**
 * This interface can be used to report a normal or an error event.
 * Clients can use these events to report normal or error conditions
 * as the user is interacting with the entity whose status is being
 * tracked.
 *   
 * @author Ali Mehregani
 */
public interface IStatusListener
{
	/**
	 * Invoked to report an error condition to the
	 * listener.
	 * 
	 * @param error The error message causing the error.
	 */
	public void handleErrorEvent (String error);
	
	
	/**
	 * Invoked to report a normal condition to the
	 * listener.
	 * 
	 */
	public void handleOKEvent ();

}
