/**********************************************************************
 * Copyright (c) 2006, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SecurityParameters.java,v 1.2 2008/01/24 02:28:53 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.security;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;

import javax.net.ssl.TrustManager;

import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class SecurityParameters implements ISecureClientParameters {
	protected KeyFactory keyFactory = null;

	protected IKeystoreManager manager = null;

	protected boolean authenticateServer;

	public SecurityParameters() {
		try {
			keyFactory = KeyFactory.getInstance("RSA");
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		manager = new KeystoreManagerImpl();
	}

	public Provider getSecurityProvider() {
		return keyFactory.getProvider();
	}

	public String getKeystoreFileName() {
		return CommonUIPlugin.getKeyStoreLocation();
	}

	public String getKeystoreFilepassword() {
		return CommonUIPlugin.getDefault().getWorkspaceName();
	}

	public IKeystoreManager getKeystoreManager() {
		return manager;
	}

	public String[] getEnabledCipherSuites() {
		// return SecurityConstants.LOW_SERVER_CIPHER_SUITES;
		return null;
	}

	public String[] getEnabledProtocols() {
		return SecurityConstants.PROTOCOLS;
	}

	public boolean getRequiresServerAuthentication() {
		return authenticateServer;
	}

	public void disableServerAuthentication() {
		TrustManager[] trustManagers = manager.getTrustManagers();
		for (int i = 0; i < trustManagers.length; i++) {
			if (trustManagers[i] instanceof X509TrustManagerImpl) {
				((X509TrustManagerImpl) trustManagers[i])
				.disableServerAuthentication();
			}
		}
	}

	public void enableServerAuthentication() {
		TrustManager[] trustManagers = manager.getTrustManagers();
		for (int i = 0; i < trustManagers.length; i++) {
			if (trustManagers[i] instanceof X509TrustManagerImpl) {
				((X509TrustManagerImpl) trustManagers[i])
				.enableServerAuthentication();
			}
		}
	}
}