/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectivityDialog.java,v 1.3 2008/01/24 02:28:53 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.internal.util;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class ConnectivityDialog extends Dialog {

    protected ConnectivityUI _connectivityUI;
    protected String fHost;
    protected String fUserId;
    protected String fPassword;
    protected String fDescription;
    protected boolean fSelectUserField=true;
	
	public ConnectivityDialog(Shell shell, String host){
		this(shell, host, "", "", true);
	}
	
	public ConnectivityDialog(Shell shell, String host, String userId){
		this(shell, host, userId, "", true);
	}
	
	public ConnectivityDialog(Shell shell, String host, String userId, boolean selectUserField){
		this(shell, host, userId, "", selectUserField);
	}	

	public ConnectivityDialog(Shell shell, String host, String userId, String password, boolean selectUserField){
		super(shell);
		
		fHost = host;
		fUserId = userId;
		fPassword = password;
		fSelectUserField = selectUserField;
	}
	
	protected Control createDialogArea(Composite parent){ 

		getShell().setText(SecurityMessages._41);
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		GridData data = GridUtil.createFill();
		layout.numColumns = 1;
		content.setLayout(layout);
		content.setLayoutData(data);

		_connectivityUI = new ConnectivityUI(getShell());
		_connectivityUI.setUserSelection(fSelectUserField);
		_connectivityUI.setDescription(fDescription);		
		_connectivityUI.createContents(content);
		_connectivityUI.setHost(fHost);
		_connectivityUI.setUserId(fUserId);
		_connectivityUI.setPassword(fPassword);

									
		return content;
	}
	
	protected Control createButtonBar(Composite parent) {
		Control control = super.createButtonBar(parent);
		getShell().setDefaultButton(getButton(IDialogConstants.OK_ID));
		return control;
		
	}
	
	protected void okPressed(){
		
		fUserId = _connectivityUI.getUserId();
		fPassword = _connectivityUI.getPassword();
		
		if(fUserId.equals(""))
		{
			String text = SecurityMessages._39;
			String info = SecurityMessages._38;
			Status err = new Status(Status.WARNING,ResourcesPlugin.PI_RESOURCES,IResourceStatus.WARNING,text,null);			
			ErrorDialog.openError(CommonUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell()
			                      ,SecurityMessages._41
			                      ,info,err);
			
			return;
		}
		if(fPassword.equals(""))
		{
			String text = SecurityMessages._40;
			String info = SecurityMessages._38;
			Status err = new Status(Status.WARNING,ResourcesPlugin.PI_RESOURCES,IResourceStatus.WARNING,text,null);			
			ErrorDialog.openError(CommonUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell()
			                      ,SecurityMessages._41
			                      ,info,err);
			
			return;
		}
		
		super.okPressed();
	}
	
	public String getUserId()		
	{
		return fUserId;
	}
	
	public String getPassword()
	{
		return fPassword;
	}
	

    public void setDescription(String desc)
    {
    	fDescription = desc;
    }	
}
