/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConnectivityUI.java,v 1.4 2010/11/08 20:42:36 mreid Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.internal.util;

import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectivityUI
{
	protected Text  fPassword;
	protected Text  fUserId;
	protected Text  fHost;
	protected String fDescription = "";
    protected boolean fSelectUserField=true;
	
	public ConnectivityUI(Shell shell){
	}
	
	public void createContents(Composite c){ 

            GridData data;
			Composite nameGroup = new Composite(c, SWT.NONE);
			GridLayout layout = new GridLayout();
			layout.numColumns = 2;
			data = GridUtil.createFill();

			nameGroup.setLayoutData(data);
			nameGroup.setLayout(layout);

			Label label = new Label(nameGroup, SWT.WRAP);
			data = new GridData();
			data.horizontalSpan = 2;
			data.widthHint = 340;
			data.horizontalAlignment = GridData.FILL_HORIZONTAL;
			label.setLayoutData(data);
			String text = fDescription;
			label.setText(text);
			
			label = new Label(nameGroup, SWT.NONE);
			data = new GridData();
			data.horizontalSpan = 2;
			label.setLayoutData(data);
			
			Label hostLabel = new Label(nameGroup, SWT.NONE);
			hostLabel.setText(SecurityMessages._35);
			fHost = new Text(nameGroup, SWT.BORDER);
			fHost.setLayoutData(GridUtil.createHorizontalFill());
			fHost.setEditable(false);
			
			Label userLabel = new Label(nameGroup, SWT.NONE);
			userLabel.setText(SecurityMessages._36);
			fUserId = new Text(nameGroup, SWT.BORDER);
			fUserId.setLayoutData(GridUtil.createHorizontalFill());
			
			Label pwdLabel = new Label(nameGroup, SWT.NONE);
			pwdLabel.setText(SecurityMessages._37);
			fPassword = new Text(nameGroup, SWT.BORDER);				
			fPassword.setLayoutData(GridUtil.createHorizontalFill());
			fPassword.setEchoChar('*');			
	}

	public Text getHostComponent()
	{
		return fHost;
	}
	public String getHost()
	{
		return fHost.getText().trim();
	}
	public void setHost(String host)
	{
		fHost.setText(host);
	}
	
    public Text getUserIdComponent()
    {
    	return fUserId;
    }
    
    public String getUserId()
    {
    	return fUserId.getText().trim();
    }
    
    public void setUserId(String userId)
    {
    	if(userId != null)
	    	fUserId.setText(userId);
	    					
		if(fSelectUserField)
		{
			fUserId.setFocus();
			fUserId.selectAll();	    	
		}
		else
		{
			fPassword.setFocus();
			fPassword.selectAll();
		}
    }
    
    public Text getPasswordComponent()
    {
    	return fPassword;
    }
    
    public String getPassword()
    {
    	return fPassword.getText().trim();
    }
    
    public void setPassword(String password)
    {
    	if(password != null)
	    	fPassword.setText(password);
	    	
		if(fSelectUserField)
		{
			fUserId.setFocus();
			fUserId.selectAll();	    	
		}
		else
		{
			fPassword.setFocus();
			fPassword.selectAll();			
		}
	    	
    }

    public void setDescription(String desc)
    {
    	fDescription = desc;
    }
    
    public void setUserSelection(boolean sel)
    {
    	fSelectUserField = sel;
    }
}
