/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CertificateDetails.java,v 1.2 2008/01/24 02:28:58 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.security.internal.util.ui;

import java.security.cert.X509Certificate;

import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.ibm.icu.text.DateFormat;

public class CertificateDetails extends Dialog {
	protected X509Certificate cert;

	public CertificateDetails(Shell shell) {
		super(shell);
	}

	public void init(X509Certificate cer) {
		this.cert = cer;
	}

	protected Control createDialogArea(Composite parent) {
		getShell().setText(SecurityMessages._17);
		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		GridData data = GridUtil.createFill();
		data.widthHint = 450;
		// data.heightHint = 300;
		layout.numColumns = 2;
		content.setLayout(layout);
		content.setLayoutData(data);

		// this should not happen
		if (this.cert == null) {
			Label errorIcon = new Label(content, SWT.NONE);
			errorIcon.setImage(Display.getCurrent().getSystemImage(SWT.ICON_ERROR));
			data = new GridData();
			data.verticalAlignment = GridData.VERTICAL_ALIGN_BEGINNING;
			data.horizontalIndent = 5;
			errorIcon.setLayoutData(data);

			Label lblErrMsg = new Label(content, SWT.NONE);
			lblErrMsg.setText(SecurityMessages._72);
			data = new GridData();
			data.verticalAlignment = GridData.VERTICAL_ALIGN_END;
			data.horizontalIndent = 5;
			lblErrMsg.setLayoutData(data);

			return content;
		}
		Label lblVersion = new Label(content, SWT.NONE);
		lblVersion.setText(SecurityMessages._18);
		data = new GridData();
		data.horizontalIndent = 5;
		lblVersion.setLayoutData(data);

		Label lblVersionValue = new Label(content, SWT.NONE);

		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblVersionValue.setLayoutData(data);

		Label lblSubject = new Label(content, SWT.NONE);
		lblSubject.setText(SecurityMessages._19);
		data = new GridData();
		data.horizontalIndent = 5;
		lblSubject.setLayoutData(data);

		Label lblSubjectValue = new Label(content, SWT.NONE);

		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblSubjectValue.setLayoutData(data);

		Label lblSigAlg = new Label(content, SWT.NONE);
		lblSigAlg.setText(SecurityMessages._20);
		data = new GridData();
		data.horizontalIndent = 5;
		lblSigAlg.setLayoutData(data);

		Label lblSigAlgValue = new Label(content, SWT.NONE);

		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblSigAlgValue.setLayoutData(data);

		Label lblKey = new Label(content, SWT.NONE);
		lblKey.setText(SecurityMessages._21);
		data = new GridData();
		data.horizontalIndent = 5;
		lblKey.setLayoutData(data);

		Label lblKeyValue = new Label(content, SWT.NONE);

		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblKeyValue.setLayoutData(data);

		Label lblPublicKey = new Label(content, SWT.NONE);
		lblPublicKey.setText(SecurityMessages._22);
		data = new GridData();
		data.verticalAlignment = GridData.BEGINNING;
		data.horizontalIndent = 5;
		lblPublicKey.setLayoutData(data);

		Text lblPublicKeyValue = new Text(content, SWT.BORDER | SWT.READ_ONLY | SWT.WRAP | SWT.V_SCROLL);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.heightHint = 60;
		data.horizontalIndent = 5;
		lblPublicKeyValue.setLayoutData(data);

		Label lblValidity = new Label(content, SWT.NONE);
		lblValidity.setText(SecurityMessages._28);
		data = new GridData();
		data.horizontalIndent = 5;
		lblValidity.setLayoutData(data);

		Label lblValidityValue = new Label(content, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblValidityValue.setLayoutData(data);

		Label lblIssuedTo = new Label(content, SWT.NONE);
		lblIssuedTo.setText(SecurityMessages._26);
		data = new GridData();
		data.verticalAlignment = GridData.BEGINNING;
		data.horizontalIndent = 5;
		lblIssuedTo.setLayoutData(data);

		Label lblIssuedToValue = new Label(content, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblIssuedToValue.setLayoutData(data);

		Label lblIssuedBy = new Label(content, SWT.NONE);
		lblIssuedBy.setText(SecurityMessages._27);
		data = new GridData();
		data.horizontalIndent = 5;
		data.verticalAlignment = GridData.BEGINNING;
		lblIssuedBy.setLayoutData(data);

		Label lblIssuedByValue = new Label(content, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblIssuedByValue.setLayoutData(data);

		Label lblSerialNum = new Label(content, SWT.NONE);
		lblSerialNum.setText(SecurityMessages._23);
		data = new GridData();
		data.horizontalIndent = 5;
		lblSerialNum.setLayoutData(data);

		Label lblSerialNumValue = new Label(content, SWT.NONE);

		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblSerialNumValue.setLayoutData(data);

		Label lblAlgorithm = new Label(content, SWT.NONE);
		lblAlgorithm.setText(SecurityMessages._29);
		data = new GridData();
		data.horizontalIndent = 5;
		lblAlgorithm.setLayoutData(data);

		Label lblAlgorithmValue = new Label(content, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalIndent = 5;
		lblAlgorithmValue.setLayoutData(data);

		Label lblSignature = new Label(content, SWT.NONE);
		lblSignature.setText(SecurityMessages._24);
		data = new GridData();
		data.verticalAlignment = GridData.BEGINNING;
		data.horizontalIndent = 5;
		lblSignature.setLayoutData(data);

		Text lblSignatureValue = new Text(content, SWT.BORDER | SWT.READ_ONLY | SWT.WRAP | SWT.V_SCROLL);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.heightHint = 60;
		data.horizontalIndent = 5;
		lblSignatureValue.setLayoutData(data);

		lblVersionValue.setText(cert.getType() + " V." + cert.getVersion());
		lblSubjectValue.setText(cert.getSubjectDN().getName());
		lblSigAlgValue.setText(cert.getSigAlgName() + ", OID = " + cert.getSigAlgOID());
		lblKeyValue.setText(cert.getPublicKey().getAlgorithm());
		lblPublicKeyValue.setText(toHexString(cert.getPublicKey().getEncoded()));
		// lblPublicKeyValue.setText(cert.getPublicKey().toString());
		lblIssuedToValue.setText(cert.getSubjectDN().getName());
		lblIssuedByValue.setText(cert.getIssuerDN().getName());
		DateFormat df = DateFormat.getDateInstance(DateFormat.LONG);
		String validity = NLS.bind(SecurityMessages._30, new Object[] { df.format(cert.getNotBefore()), df.format(cert.getNotAfter()) });
		lblValidityValue.setText(validity);
		lblSerialNumValue.setText(cert.getSerialNumber().toString());
		lblAlgorithmValue.setText(cert.getSigAlgName());
		// lblSignatureValue.setText(getThumbprintFromCertificate(cert));
		lblSignatureValue.setText(toHexString(cert.getSignature()));

		return content;
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
	}

	protected String toHexString(byte[] data) {
		StringBuffer hexString = new StringBuffer();
		int i = 0;
		for (; i < data.length - 1; i++) {
			hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
			if ((i + 1) % 16 == 0)
				hexString.append("\n");
			else if ((i + 1) % 8 == 0)
				hexString.append("    ");
			else
				hexString.append(" ");
		}
		for (; i < data.length; i++) {
			hexString.append(Integer.toHexString(0xFF & data[i] | 0x100).substring(1));
		}
		return hexString.toString().toUpperCase();
	}


}
