/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SaveCertificate.java,v 1.3 2008/01/24 02:28:58 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.security.internal.util.ui;

import java.security.KeyStore;
import java.util.Enumeration;

import org.eclipse.hyades.security.internal.util.SecurityMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveCertificate extends Dialog{
	protected String alias = null;

	protected Text txtAliasValue = null;

	protected Button okBtn = null;

	protected String title = SecurityMessages._17;

	protected Label lblErrMsg = null;

	protected Label errorIcon = null;

	protected KeyStore ks = null;

	public SaveCertificate(Shell shell, KeyStore ks) {
		super(shell);
		this.ks = ks;
	}

//	public void init(X509Certificate cer) {
//		this.cert = cer;
//		String storePath = HyadesUIPlugin.getKeyStoreLocation();
//		String passw = HyadesUIPlugin.getInstance().getWorkspaceName();
//
//		try {
//			ks = KeystoreHelper.createKeyStore(storePath, passw);
//		} catch (KeyStoreException exc) {
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._57, HyadesUIPlugin.getKeyStoreLocation()), exc);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._59, err);
//		} catch (NoSuchAlgorithmException e) {
//
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._47, HyadesUIPlugin.getKeyStoreLocation()), e);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._59, err);
//		} catch (CertificateException exc) {
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._46, storePath), exc);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._59, err);
//		} catch (NoSuchProviderException e) {
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, SecurityMessages._58, e);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, NLS.bind(SecurityMessages._57, HyadesUIPlugin.getKeyStoreLocation()), err);
//		} catch (IOException e) {
//
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._61, storePath), e);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._59, err);
//		}
//	}

	protected Control createDialogArea(Composite parent) {
		getShell().setText(title);
		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		GridData data = GridUtil.createFill();
		data.widthHint = 450;
		// data.heightHint = 300;
		layout.numColumns = 2;
		content.setLayout(layout);
		content.setLayoutData(data);

		errorIcon = new Label(content, SWT.NONE);
		errorIcon.setImage(Display.getCurrent().getSystemImage(SWT.ICON_ERROR));
		data = new GridData();
		data.horizontalIndent = 5;
		errorIcon.setLayoutData(data);
		errorIcon.setVisible(false);

		lblErrMsg = new Label(content, SWT.NONE);
		String text = SecurityMessages._65;
		text = text.length() > SecurityMessages._66.length() ? text : SecurityMessages._66;
		lblErrMsg.setText(text);
		data = new GridData();
		data.horizontalIndent = 5;
		lblErrMsg.setLayoutData(data);
		lblErrMsg.setVisible(false);

		Label lblAlias = new Label(content, SWT.NONE);
		lblAlias.setText(SecurityMessages._1);
		data = new GridData();
		data.verticalAlignment = GridData.BEGINNING;
		data.horizontalIndent = 5;
		lblAlias.setLayoutData(data);

		txtAliasValue = new Text(content, SWT.BORDER);
		txtAliasValue.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String value = txtAliasValue.getText();
				if (value == null || value.trim().length() == 0) {
					SaveCertificate.this.lblErrMsg.setVisible(true);
					SaveCertificate.this.lblErrMsg.setText(SecurityMessages._65);
					SaveCertificate.this.errorIcon.setVisible(true);
					okBtn.setEnabled(false);
				} else {
					try {
						Enumeration enu = ks.aliases();
						while (enu.hasMoreElements()) {
							String entry = (String) enu.nextElement();
							if (entry.equals(value.trim())) {
								SaveCertificate.this.lblErrMsg.setVisible(true);
								SaveCertificate.this.lblErrMsg.setText(SecurityMessages._66);
								SaveCertificate.this.errorIcon.setVisible(true);
								okBtn.setEnabled(false);
							}
						}
					} catch (Exception exp) {
					}
					SaveCertificate.this.alias = value.trim();
					SaveCertificate.this.lblErrMsg.setVisible(false);
					SaveCertificate.this.errorIcon.setVisible(false);
					okBtn.setEnabled(true);
				}
			}
		});
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.minimumHeight = 15; // minimumHeight added for defect 144501 --Liz Dancy.
		data.horizontalIndent = 5;
		txtAliasValue.setLayoutData(data);
		return content;
	}

	protected void okPressed() {
//		String storePath = HyadesUIPlugin.getKeyStoreLocation();
//		String passw = HyadesUIPlugin.getInstance().getWorkspaceName();
//		try {
//			ks.setCertificateEntry(alias, cert);
//			KeystoreHelper.persistKeyStore(ks, storePath, passw);
//		} catch (IOException e) {
//
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._54, storePath), e);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._53, err);
//		} catch (CertificateException exc) {
//
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._55, storePath), exc);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._53, err);
//		} catch (KeyStoreException exc) {
//
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._56, HyadesUIPlugin.getKeyStoreLocation()), exc);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._53, err);
//		} catch (NoSuchAlgorithmException exc2) {
//			Status err = new Status(Status.ERROR, ResourcesPlugin.PI_RESOURCES, IResourceStatus.ERROR, NLS.bind(SecurityMessages._47, HyadesUIPlugin.getKeyStoreLocation()), exc2);
//			ErrorDialog.openError(Display.getCurrent().getActiveShell(), SecurityMessages._41, SecurityMessages._53, err);
//		}
		setReturnCode(OK);
		close();
	}

	protected void createButtonsForButtonBar(Composite parent) {
		okBtn = createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
		okBtn.setEnabled(false);
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
	}

	public String getAlias() {
		return alias;
	}
}
