/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IProfileEventListener.java,v 1.1 2007/11/27 04:52:10 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;


/**
 * A profile event listener registers with the profile plug-in
 * to receive profile event notification from the application being profiled.
  * <p>
 * Clients may implement this interface.
 * </p> 
 */
public interface IProfileEventListener {
	/**
	 * Notifies this listener of the given profile event.
	 *
	 * @param event the profile event
	 */
	public void handleProfileEvent(ProfileEvent event);
}
