/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITraceSelection.java,v 1.1 2007/11/27 04:52:10 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui;

import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * A selection containing elements.
 * The selection is updated every time a new element is
 * selected in one of the trace views. 
 */
public interface ITraceSelection extends IStructuredSelection {

	/**
	 * 
	 * @param object new selection
	 */
	public void add(Object object);
	
	/**
	 * 
	 * @param object
	 * @return true if the object is selected
	 */
	public boolean contains(Object object);
	

}
