/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ViewSelectionChangedEvent.java,v 1.3 2008/03/27 01:23:25 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

/**
 * A PDViewEvent is sent when the selection changes in one of the problem determination views 
 * <p>
 * The <code>getSource()</code> source of the selection event
 * returns the element associated with the event.
 * </p>
 */
public final class ViewSelectionChangedEvent {
	
	protected Object source;
	
	protected Object event;
	
	/**
	 * The constructor for the event
	 *
	 */
	public ViewSelectionChangedEvent() {
	}
	
	/**
	 * The source of the view selection event.
	 * @return an Object
	 */
	public Object getSource()
	{
		return source;
	}
	
	/**
	 * Sets the source of the view selection event.
	 * @param eventSource an Object
	 */
	public void setSource(Object eventSource)
	{
		source = eventSource;
	}
	/**
	 * Sets the selection event
	 * @param event
	 */
	public void setEvent(Object event){
		this.event = event;
	}
	
	/**
	 * Returns the selection event.
	 * @return
	 */
	public Object getEvent(){
		return event;
	}
}

