/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * 
 * Abstract class that each org.eclipse.hyades.ui.analyzerExtenstions extension should implement 
 * for any open view action that is assocated with a type.
 * <p>
 * Each open view action is associated with a type, and <code>getViewID</code> method returns the
 * view id of the actions trying to open. The view id is used on object type and view association
 * validation.
 * <p>
 * 
 * @author ewchan
 * @since 4.0
 * @see org.eclipse.jface.action.Action
 */

public abstract class OpenAssociatedTraceViewAction extends Action {
	

	
	/**
	 * Constructor
	 * 
	 * @see org.eclipse.jface.action.Action
	 */
	public OpenAssociatedTraceViewAction() {
		super();
	}

	/**
	 * Constructor
	 * 
	 * @see org.eclipse.jface.action.Action
	 */
	public OpenAssociatedTraceViewAction(String text, ImageDescriptor image) {
		super(text, image);
	}

	/**
	 * Constructor
	 * 
	 * @see org.eclipse.jface.action.Action
	 */
	public OpenAssociatedTraceViewAction(String text, int style) {
		super(text, style);
	}

	/**
	 * Constructor
	 * 
	 * @see org.eclipse.jface.action.Action
	 */
	public OpenAssociatedTraceViewAction(String text) {
		super(text);
	}

	/**
	 * Return view id that action opens.
	 * 
	 * @return Fully qualify view id
	 */
	public abstract String getViewID();
	
	/**
	 * Returns true if this action is enabled for the given selected object. 
	 * @param obj
	 * @return
	 */
	public boolean isEnabledForObject(Object obj)
	{
		return true;
	}
}
