/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITraceUIHelper.java,v 1.1 2008/01/31 03:27:03 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.trace.ui.provisional;

import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.tptp.platform.extensions.IApplicationManager;
/**
 * 
 * @author slavescu
 *
 */
public interface ITraceUIHelper {

	public static final String TPTP_TRACE_UI_HELPER = "TPTP/TRACE/TraceUIHelper";
	public static final ITraceUIHelper INSTANCE = (ITraceUIHelper)IApplicationManager.INSTANCE.createDefaultHandlerInstance(TPTP_TRACE_UI_HELPER);

	public void disposeTraceUIManager();

	public void resetMonitors();

	public boolean isViewForType(String logViewId, String type);

	public IPreferenceStore getTraceUIPreferenceStore();

	public Application getTraceUIApplication();
	
}
