/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesAdapterFactory.java,v 1.3 2008/01/24 02:28:59 apnan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.adapter;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.hyades.ui.util.INamedElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;

/**
 * The adapter factory that creates the Hyades' adapters.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class HyadesAdapterFactory 
implements IAdapterFactory, IDisposable
{
	/**
	 * Singleton for HyadesAdapterFactory
	 */
	public static final HyadesAdapterFactory INSTANCE = new HyadesAdapterFactory();
	
	protected HyadesWorkbenchAdapter hyadesWorkbenchAdapter;
	
	/**
	 * Constructor for HyadesAdapterFactory
	 */
	protected HyadesAdapterFactory()
	{
		hyadesWorkbenchAdapter = new HyadesWorkbenchAdapter();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		hyadesWorkbenchAdapter = null;
	}
	
	/**
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapterList()
	 */
	public Class[] getAdapterList()
	{
		return new Class[] {
			IHyadesWorkbenchAdapter.class,
			IWorkbenchAdapter.class,
			IPropertySource.class
		};
	}

	/**
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object, java.lang.Class)
	 */
	public Object getAdapter(Object adaptableObject, Class adapterType)
	{
		if((adapterType == IHyadesWorkbenchAdapter.class) || (adapterType == IWorkbenchAdapter.class))
			return getHyadesWorkbenchAdapter(adaptableObject);
		
		if(adapterType == IPropertySource.class)
			return getPropertySource(adaptableObject);
			
		return null;
	}
	
	/**
	 * Returns the Hyades workbench adapter associated with a given 
	 * adaptable object.
	 * @param adaptableObject
	 * @return IHyadesWorkbenchAdapter
	 */
	protected IHyadesWorkbenchAdapter getHyadesWorkbenchAdapter(Object adaptableObject)
	{
		if(adaptableObject instanceof LogicalFolder)
			return hyadesWorkbenchAdapter;
			
		return null;
	}
	
	/**
	 * Returns the property source associated with a given adaptable object.
	 * @param adaptableObject
	 * @return IPropertySource
	 */
	protected IPropertySource getPropertySource(Object adaptableObject)
	{
		if(adaptableObject instanceof INamedElement)
			return new NamedElementPropertySource((INamedElement)adaptableObject);
			
		return null;
	}
}
