/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IHyadesWorkbenchAdapter.java,v 1.2 2006/09/20 19:49:11 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.adapter;

import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * Hyades extension for the Eclipse's workbench adapter.
 *  
 * @author marcelop
 * @since 0.0.1 
 */
public interface IHyadesWorkbenchAdapter 
extends IWorkbenchAdapter
{
	/**
	 * Returns the description text for this element.  Returns an empty 
	 * string if there is no appropriate description text for this object.
	 *
	 * @param object The object to get a description for.
	 */
	public String getDescription(Object object);

	/**
	 * Returns whether the given element has children.
	 * 
	 * <p>Intended as an optimization for when the viewer does not
	 * need the actual children.  Clients may be able to implement
	 * this more efficiently than <code>getChildren</code>.
	 *
	 * @param element the element
	 * @return <code>true</code> if the given element has children,
	 *  and <code>false</code> if it has no children
	 */
	public boolean hasChildren(Object element);	
}
