/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExportViewer.java,v 1.2 2006/09/20 19:49:11 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.extension;

import org.eclipse.jface.viewers.Viewer;

/**
 * Interface for a viewer that supports the TPTP generic 'export data' mechanism. 
 * This interface is used in conjunction with the org.eclipse.hyades.ui.exportViewer extension point
 * 
 * @author popescu
 * @since 4.1.0
 */
public interface IExportViewer {

	/**
	 * 
	 * @return llsit of controls containing the data to be exported
	 */
    public Object[] getViewerControls();
    
	/**
	 * 
	 * @return view title
	 */
    public String getViewerTitle();
    
	/**
	 * 
	 * @return viewers associated with this view, if applicable
	 * can be a TreeViewer, TableTreeViewer or null if the view is not using a viewer
	 */
    public Viewer[] getExportViewer();
    
    /**
     * 
     * @return the model input for this view
     */
    public Object getModelObject();
    
    
}
