/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterActions.java,v 1.2 2006/09/20 19:49:12 ewchan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters;

import org.eclipse.hyades.ui.filters.internal.actions.FiltersSelectionAction;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.IAction;

public class FilterActions {
	
	/**
	 * Creates a filters drop down action for the UI for the given IFilterViewer instance. 
	 * 
	 * @param IFilterViewer The viewer that the action to be returned is associated with. 
	 * @return The filters drop down action associated with the given
	 * IFilterViewer instance.
	 */	
	public static IAction getFiltersSelectionAction(IFilterViewer filterViewer)
	{
		return new FiltersSelectionAction(FilterInformationManager.instance(filterViewer));
	}
}
