/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FiltersStandardTabUI.java,v 1.2 2006/09/20 19:49:12 ewchan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersTabUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public abstract class FiltersStandardTabUI extends FiltersTabUI {

	/**
	 * Creates the control UI for the standard tab given the Composite parent.
	 * 
	 * @param parent the composite parent
	 * @return the created control for this standard tab
	 */
	public abstract Control createControl(Composite parent);

	/**
	 * This method is called when the tab UI is loaded or shown.  The UI
	 * is to populate its data for a dialog loading with the given SimpleSearchQuery filter.
	 * 
	 * @param filter the SimpleSearchQuery filter this view is initialized with
	 */
	public abstract void initializeFrom(SimpleSearchQuery filter);
	
	/**
	 * This method is called to apply the filter information of this UI on the given filter.
	 * 
	 * @return the filter created by this tab for its UI, a SimpleSearchQuery instance
	 */
	public abstract SimpleSearchQuery performApply();
	
	/**
	 * Returns the tab name that is displayed in the filters dialog.
	 * 
	 * @return the tab name
	 */
	public String getTabName()
	{
		return CommonUIMessages._80;
	}

	/**
	 * Returns the tab image that is displayed in the filters dialog.
	 * 
	 * @return the tab image
	 */
	public Image getTabImage()
	{
		return CommonUIImages.INSTANCE.getImage(CommonUIImages.IMG_UI_VIEW_FILTER_OBJ);
	}
}
