/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAdvancedTabAttributeSet.java,v 1.2 2006/09/20 19:49:12 ewchan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters;

/**
 * This interface contains the definition for the attribute set
 * displayed in the advanced tab of the filter dialog, associated with
 * some filter type.  Implementing classes need to define which IFilterAttribute
 * instances are shown in the advanced tab UI.
 */
public interface IAdvancedTabAttributeSet {

	/**
	 * Returns the attributes displayable in the advanced tab of the
	 * filters dialog.
	 * 
	 * @return An array of IFilterAttribute instances.
	 */
	public IFilterAttribute[] getAttributes();
}
