/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFilterQueryProvider.java,v 1.2 2006/09/20 19:49:12 ewchan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

/**
 * This interface is passed to an IFilterViewer object.  The IFilterViewer
 * implementor can then use the methods to get information about the filter
 * or send information to the internal filtering code about the viewer.  
 *
 */
public interface IFilterQueryProvider {

	/**
	 * Returns the current filter applied to this IFilterViewer.  It is a merged
	 * query with the standard tab query and advanced tab query.
	 *  
	 * @return returns a SimpleSearchQuery instance, being the current filter
	 */
	public SimpleSearchQuery getCurrentFilter();

	/**
	 * Returns the current standard tab filter applied to this IFilterViewer.
	 *  
	 * @return returns a SimpleSearchQuery instance, being the current standard tab filter
	 */	
	public SimpleSearchQuery standardQuery();
	
	/**
	 * Returns the current advanced tab filter applied to this IFilterViewer.
	 *  
	 * @return returns a SimpleSearchQuery instance, being the current advanced tab filter
	 */	
	public SimpleSearchQuery advancedQuery();

	/**
	 * Updates the standard tab filter query with the given query and opens the
	 * filter dialog on the standard tab.
	 * 
	 * @param standardQuery a SimpleSearchQuery, the updated standard tab query instance
	 */
	public void updateStandardQuery(SimpleSearchQuery standardQuery);
	
	/**
	 * Updates the advanced tab filter query with the given query and opens the
	 * filter dialog on the advanced tab.
	 * 
	 * @param advancedQuery a SimpleSearchQuery, the updated advanced tab query instance
	 */
	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery);
	
	/**
	 * Updates the advanced tab filter query with the given query and opens the
	 * filter dialog on the advanced tab.  When opening the advanced tab it selects the row
	 * in the advanced tab dialog with the given row index.
	 * 
	 * @param advancedQuery a SimpleSearchQuery, the updated advanced tab query instance
	 * @param advancedTabSelectionIndex an integer, the row index to select when opening
	 * the advanced tab dialog
	 */
	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery, int advancedTabSelectionIndex);	
	
	/**
	 * This method must be called when the class implementing IFilterViewer is disposed, so that
	 * the viewer can be dropped from the internal filter update listeners.
	 */
	public void viewerDisposed();
}
