/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFilterScopes.java,v 1.1 2006/08/16 21:15:23 amehregani Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters;

/**
 * Contains the default filter scopes defined 
 *
 */
public interface IFilterScopes {
	/**
	 * This filter scope is associated with profiling agents.
	 */
	public static final String PROFILING_AGENT_FILTER_SCOPE = "ProfilingAgentScope";
	
	/**
	 * This filter scope is associated with logging agents.
	 */	
	public static final String LOGGING_AGENT_FILTER_SCOPE = "LoggingAgentScope";
	
	/**
	 * This filter scope is associated with importing trace profiling files.
	 */	
	public static final String IMPORT_TRACE_FILTER_SCOPE = "ImportTraceScope";
	
	/**
	 * This filter scope is associated with importing log files.
	 */		
	public static final String IMPORT_LOG_FILTER_SCOPE = "ImportLogScope";
	
	/**
	 * This scope is associated with symptom analysis. 
	 */
	public static final String SYMPTOM_FILTER_SCOPE = "SymptomScope";
}
