/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFilterViewer.java,v 1.2 2006/09/20 19:49:12 ewchan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters;


/**
 * The viewer associated with the view filters to be shown. 
 */
public interface IFilterViewer {
	
	/**
	 * When a filter is selected or changed, this method is called to signal to the viewer
	 * that one of its filters have changed or updated.  The implementor can handle this in its
	 * choosing (examples: lazy refreshing, immediate refreshing).
	 */
	public void filterUpdated();
	
	
	/**
	 * When the action is created, this method is called providing the IFilterQueryProvider to
	 * the viewer.  The viewer could then use this method to get the filter, or update filter queries
	 * in some programmatic way.  The IFilterQueryProvider must also be used to call
	 * #IFilterQueryProvider.viewerDisposed() when this viewer is disposed.
	 */
	public void setFilterQueryProvider(IFilterQueryProvider filterQueryProvider);


	/**
	 * Returns the filter scope associated with the IFilterViewer implementor.  The filter scope
	 * is used to determine what filter types associated with this viewer.  If a filter type is
	 * associated with any scope returned here its filters are displayed and can be edited/created
	 * from the action of this IFilterViewer.
	 */
	public String[] getFilterScope();
}
