/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CreateOrEditFilter.java,v 1.3 2006/10/04 17:49:40 ewchan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/

package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterTypeDialog;
import org.eclipse.hyades.ui.filters.internal.dialogs.FilterUIUtil;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersDialog;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.ui.internal.filters.IFilterType;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class CreateOrEditFilter {

	
	public static void run(FilterInformationManager fi, String selectedFilterName)
	{
		run(fi, 0, null, null, -1, selectedFilterName);
	}
	
	public static void run(FilterInformationManager fi)
	{
		run(fi, 0, null, null, -1, fi.selectedFilterName());
	}		

	public static void run(FilterInformationManager fi, int openTabIndex, SimpleSearchQuery standardTabQuery, SimpleSearchQuery advancedTabQuery, int advancedTabSelectionIndex, String selectedFilterName)
	{
		run(fi, openTabIndex, standardTabQuery, advancedTabQuery, advancedTabSelectionIndex, selectedFilterName!=null?fi.filter(selectedFilterName):null);		
	}
	

	public static void run(FilterInformationManager fi, int openTabIndex, SimpleSearchQuery standardTabQuery, SimpleSearchQuery advancedTabQuery, int advancedTabSelectionIndex)
	{
		run(fi, openTabIndex, standardTabQuery, advancedTabQuery, advancedTabSelectionIndex, fi.selectedFilter());
	}	
	
	public static void run(FilterInformationManager fi, int openTabIndex, SimpleSearchQuery standardTabQuery, SimpleSearchQuery advancedTabQuery, int advancedTabSelectionIndex, FilterQueries selectedFilter)
	{
		FilterQueries filter = selectedFilter;
		FilterQueries changedFilter = null;		
		// added for defect_155694 in order to eliminate the
		// select Log Type dialog when there is only one possible
		// Log Type. This checks to see if there is more than one
		// and then proceeds as before. Otherwise, it skips right to the
		// Log creation/editing dialog.
		// Liz Dancy
		if (filter == null || CommonUIMessages._111.equals(filter.name())) {
			String type;

			if (fi.getFilterTypes().length > 1) {
				FilterTypeDialog filterTypeDialog  = FilterUIUtil.getFiltersTypeDialog(fi);
				filterTypeDialog.open();
				IFilterType filterType = filterTypeDialog.selectedFilterType();
				type = filterType.id();
			} else {
				type = fi.getFilterTypes()[0].id();
			}

			FilterQueries fq = fi.createFilterQueries(type);
			FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(fq, fi, 0);

			if (type == null)
				return;


			changedFilter = fi.createFilterQueries(type, standardTabQuery, advancedTabQuery);
		} else {
			changedFilter = filter.copy();
			
			if (standardTabQuery != null)
				filter.standard(standardTabQuery);
			
			if (advancedTabQuery != null)
				filter.advanced(advancedTabQuery);
		}
		

		FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(changedFilter, fi, openTabIndex, advancedTabSelectionIndex);
		filtersDialog.open();
		
		if (filtersDialog.getReturnCode() == FiltersDialog.OK) {
			if (filter != null && !CommonUIMessages._111.equals(filter.name())){
				fi.removeFilter(filter);
			}
				
			fi.addFilter(changedFilter);
			
			fi.selectedFilterName(changedFilter.name());
			fi.save();
		} else {
			fi.restore();
		}		
	}
}
