/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterQueryProvider.java,v 1.4 2008/01/24 02:29:00 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation
 ***********************************************************************/
package org.eclipse.hyades.ui.filters.internal.actions;

import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.ui.filters.IFilterQueryProvider;
import org.eclipse.hyades.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.ui.filters.internal.util.FilterQueries;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class FilterQueryProvider implements IFilterQueryProvider
{
	protected FilterInformationManager _fi;
	
	public FilterQueryProvider(FilterInformationManager fi)
	{
		_fi = fi;
	}

	public SimpleSearchQuery standardQuery() {
		FilterQueries fq = _fi.selectedFilter();
		
		/* Navid Mehregani - bugzilla 171424: We're never suppose to change the standard or  
		 * advanced query of 'No filter', thus this method should never return them. */
		if ((fq != null) && (!CommonUIMessages._111.equals(fq.name())))
		{
			return fq.standard();
		}
		else
		{
			SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
			LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			query.setWhereExpression(logicalExpression);
			
			return query;
		}
	}

	public SimpleSearchQuery advancedQuery() {
		FilterQueries fq = _fi.selectedFilter();
		
		/* Navid Mehregani - bugzilla 171424: We're never suppose to change the standard or  
		 * advanced query of 'No filter', thus this method should never return them. */
		if ((fq != null) && (!CommonUIMessages._111.equals(fq.name())))
		{
			return fq.advanced();
		}
		else
		{
			SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
			LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			query.setWhereExpression(logicalExpression);
			
			return query;
		}
	}

	public void updateStandardQuery(SimpleSearchQuery standardQuery) {
		CreateOrEditFilter.run(_fi, 0, standardQuery, null, -1);
	}

	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery) {
		CreateOrEditFilter.run(_fi, 1, null, advancedQuery, -1);
	}
	
	public void updateAdvancedQuery(SimpleSearchQuery advancedQuery, int advancedTabSelectionIndex) {
		CreateOrEditFilter.run(_fi, 1, null, advancedQuery, advancedTabSelectionIndex);
	}

	public SimpleSearchQuery getCurrentFilter() {
		return _fi.getCurrentFilter();
	}

	public void viewerDisposed() {
		_fi.viewerDisposed();
	}
}
